﻿//////////////////////////////////////////////
// LogWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class LogManager ;
}

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkAstraeusWrap
{
	class DLL_ASTRAEUS_EXPORT LogWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env, LogManager* targetLogManager) ;

			// Callbacks
			static nkScripts::OutputValue log (LogManager* targetLogManager, const nkScripts::DataStack& stack) ;
	} ;
}